<?php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/rbac.php';
require_login(); require_role(['admin','guru']);
require __DIR__ . '/../includes/header.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$data = ['nama'=>'','hp'=>'','email'=>'','alamat'=>''];
if ($id) {
  $stmt = $pdo->prepare("SELECT * FROM wali WHERE id=?");
  $stmt->execute([$id]);
  $data = $stmt->fetch();
  if (!$data) { die("Wali tidak ditemukan"); }
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  verify_csrf();
  $nama = $_POST['nama'] ?? '';
  $hp = $_POST['hp'] ?? '';
  $email = $_POST['email'] ?? '';
  $alamat = $_POST['alamat'] ?? '';
  if ($id) {
    $stmt = $pdo->prepare("UPDATE wali SET nama=?, hp=?, email=?, alamat=? WHERE id=?");
    $stmt->execute([$nama,$hp,$email,$alamat,$id]);
  } else {
    $stmt = $pdo->prepare("INSERT INTO wali(nama,hp,email,alamat) VALUES (?,?,?,?)");
    $stmt->execute([$nama,$hp,$email,$alamat]);
  }
  header("Location: wali_list.php"); exit;
}
?>
<h4><?= $id? 'Edit' : 'Tambah' ?> Wali</h4>
<form method="post" class="row g-3">
  <?php csrf_field(); ?>
  <div class="col-md-6">
    <label class="form-label">Nama</label>
    <input name="nama" class="form-control" required value="<?= htmlspecialchars($data['nama']) ?>">
  </div>
  <div class="col-md-3">
    <label class="form-label">HP (WA)</label>
    <input name="hp" class="form-control" value="<?= htmlspecialchars($data['hp']) ?>">
  </div>
  <div class="col-md-3">
    <label class="form-label">Email</label>
    <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($data['email']) ?>">
  </div>
  <div class="col-12">
    <label class="form-label">Alamat</label>
    <textarea name="alamat" class="form-control"><?= htmlspecialchars($data['alamat']) ?></textarea>
  </div>
  <div class="col-12">
    <button class="btn btn-primary">Simpan</button>
    <a class="btn btn-secondary" href="wali_list.php">Batal</a>
  </div>
</form>
<?php require __DIR__ . '/../includes/footer.php'; ?>
