<?php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/rbac.php';
require_login(); require_role(['admin','guru']);
require __DIR__ . '/../includes/header.php';

if (isset($_GET['delete'])) {
  $id = (int)$_GET['delete'];
  $pdo->prepare("DELETE FROM santri WHERE id=?")->execute([$id]);
  header("Location: santri_list.php"); exit;
}
$rows = $pdo->query("SELECT s.*, k.nama as nama_kelas FROM santri s LEFT JOIN kelas k ON k.id=s.kelas_id ORDER BY s.nama")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4>Data Santri</h4>
  <a class="btn btn-primary" href="santri_form.php">Tambah Santri</a>
</div>
<div class="table-responsive">
<table class="table table-striped">
  <thead><tr><th>Nama</th><th>NIS</th><th>Kelas</th><th>Wali</th><th>Aksi</th></tr></thead>
  <tbody>
  <?php foreach ($rows as $r): 
    $wal = $pdo->prepare("SELECT w.nama FROM santri_wali sw JOIN wali w ON w.id=sw.wali_id WHERE sw.santri_id=?");
    $wal->execute([$r['id']]);
    $wali = implode(', ', array_column($wal->fetchAll(), 'nama'));
  ?>
    <tr>
      <td><?= htmlspecialchars($r['nama']) ?></td>
      <td><?= htmlspecialchars($r['nis']) ?></td>
      <td><?= htmlspecialchars($r['nama_kelas']) ?></td>
      <td><?= htmlspecialchars($wali) ?></td>
      <td>
        <a class="btn btn-sm btn-outline-secondary" href="santri_form.php?id=<?= $r['id'] ?>">Edit</a>
        <a class="btn btn-sm btn-outline-danger" href="?delete=<?= $r['id'] ?>" onclick="return confirm('Hapus data?')">Hapus</a>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
