<?php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/rbac.php';
require_login(); require_role(['admin','guru']);
require __DIR__ . '/../includes/header.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$data = ['nama'=>'','nis'=>'','kelas_id'=>null,'jk'=>'L','tgl_lahir'=>null,'alamat'=>''];
if ($id) {
  $stmt = $pdo->prepare("SELECT * FROM santri WHERE id=?");
  $stmt->execute([$id]);
  $data = $stmt->fetch();
  if (!$data) { die("Santri tidak ditemukan"); }
}

$kelas = $pdo->query("SELECT id,nama FROM kelas ORDER BY nama")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  verify_csrf();
  $nama = $_POST['nama'] ?? '';
  $nis = $_POST['nis'] ?? '';
  $kelas_id = $_POST['kelas_id'] ?: null;
  $jk = $_POST['jk'] ?? 'L';
  $tgl = $_POST['tgl_lahir'] ?: null;
  $alamat = $_POST['alamat'] ?? '';
  if ($id) {
    $stmt = $pdo->prepare("UPDATE santri SET nama=?, nis=?, kelas_id=?, jk=?, tgl_lahir=?, alamat=? WHERE id=?");
    $stmt->execute([$nama,$nis,$kelas_id,$jk,$tgl,$alamat,$id]);
  } else {
    $stmt = $pdo->prepare("INSERT INTO santri(nama,nis,kelas_id,jk,tgl_lahir,alamat) VALUES (?,?,?,?,?,?)");
    $stmt->execute([$nama,$nis,$kelas_id,$jk,$tgl,$alamat]);
    $id = (int)$pdo->lastInsertId();
  }
  header("Location: santri_list.php"); exit;
}
?>
<h4><?= $id? 'Edit' : 'Tambah' ?> Santri</h4>
<form method="post" class="row g-3">
  <?php csrf_field(); ?>
  <div class="col-md-6">
    <label class="form-label">Nama</label>
    <input name="nama" class="form-control" required value="<?= htmlspecialchars($data['nama']) ?>">
  </div>
  <div class="col-md-3">
    <label class="form-label">NIS</label>
    <input name="nis" class="form-control" value="<?= htmlspecialchars($data['nis']) ?>">
  </div>
  <div class="col-md-3">
    <label class="form-label">Kelas</label>
    <select name="kelas_id" class="form-select">
      <option value="">-</option>
      <?php foreach ($kelas as $k): ?>
        <option value="<?= $k['id'] ?>" <?= ($data['kelas_id']==$k['id']?'selected':'') ?>><?= htmlspecialchars($k['nama']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-3">
    <label class="form-label">Jenis Kelamin</label>
    <select name="jk" class="form-select">
      <option value="L" <?= $data['jk']=='L'?'selected':'' ?>>Laki-laki</option>
      <option value="P" <?= $data['jk']=='P'?'selected':'' ?>>Perempuan</option>
    </select>
  </div>
  <div class="col-md-3">
    <label class="form-label">Tanggal Lahir</label>
    <input type="date" name="tgl_lahir" class="form-control" value="<?= htmlspecialchars($data['tgl_lahir']) ?>">
  </div>
  <div class="col-12">
    <label class="form-label">Alamat</label>
    <textarea name="alamat" class="form-control"><?= htmlspecialchars($data['alamat']) ?></textarea>
  </div>
  <div class="col-12">
    <button class="btn btn-primary">Simpan</button>
    <a class="btn btn-secondary" href="santri_list.php">Batal</a>
  </div>
</form>
<?php require __DIR__ . '/../includes/footer.php'; ?>
