<?php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/rbac.php';
require_login(); require_role(['admin','guru']);
require __DIR__ . '/../includes/header.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  verify_csrf();
  $santri_id = (int)($_POST['santri_id'] ?? 0);
  $tanggal = $_POST['tanggal'] ?? date('Y-m-d');
  $materi = $_POST['materi'] ?? '';
  $catatan = $_POST['catatan'] ?? '';
  if ($santri_id && $materi) {
    $stmt = $pdo->prepare("INSERT INTO hafalan(santri_id,tanggal,materi,catatan) VALUES(?,?,?,?)");
    $stmt->execute([$santri_id,$tanggal,$materi,$catatan]);
  }
}
$santri = $pdo->query("SELECT id,nama FROM santri ORDER BY nama")->fetchAll();
$rows = $pdo->query("SELECT h.id, s.nama, h.tanggal, h.materi, h.catatan FROM hafalan h JOIN santri s ON s.id=h.santri_id ORDER BY h.tanggal DESC, s.nama")->fetchAll();
?>
<h4>Setoran Hafalan</h4>
<form method="post" class="row g-3 align-items-end mb-3">
  <?php csrf_field(); ?>
  <div class="col-md-5">
    <label class="form-label">Santri</label>
    <select name="santri_id" class="form-select"><?php foreach ($santri as $s): ?><option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['nama']) ?></option><?php endforeach; ?></select>
  </div>
  <div class="col-md-3">
    <label class="form-label">Tanggal</label>
    <input type="date" name="tanggal" class="form-control" value="<?= date('Y-m-d') ?>">
  </div>
  <div class="col-md-4">
    <label class="form-label">Materi (mis. QS Al-Baqarah 1-5)</label>
    <input name="materi" class="form-control" required>
  </div>
  <div class="col-12">
    <label class="form-label">Catatan</label>
    <textarea name="catatan" class="form-control" rows="2"></textarea>
  </div>
  <div class="col-12"><button class="btn btn-primary">Simpan</button></div>
</form>
<div class="table-responsive">
<table class="table table-striped">
  <thead><tr><th>Santri</th><th>Tanggal</th><th>Materi</th><th>Catatan</th></tr></thead>
  <tbody>
  <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= htmlspecialchars($r['nama']) ?></td>
      <td><?= htmlspecialchars($r['tanggal']) ?></td>
      <td><?= htmlspecialchars($r['materi']) ?></td>
      <td><?= htmlspecialchars($r['catatan']) ?></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
