<?php
// includes/header.php
$config = require __DIR__ . '/../config/config.php';
$base = rtrim($config['base_url'], '/');
?><!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($config['app_name']) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?= $base ?>/assets/css/app.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg bg-body-tertiary border-bottom mb-3">
  <div class="container">
    <a class="navbar-brand" href="<?= $base ?>/index.php">TPQ Al-Washil</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav" aria-controls="nav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="nav">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <?php if (is_logged_in()): ?>
          <li class="nav-item"><a class="nav-link" href="<?= $base ?>/index.php">Dashboard</a></li>
          <?php if (in_array(user_role(), ['admin','guru'])): ?>
            <li class="nav-item"><a class="nav-link" href="<?= $base ?>/pages/santri_list.php">Santri</a></li>
            <li class="nav-item"><a class="nav-link" href="<?= $base ?>/pages/wali_list.php">Wali</a></li>
            <li class="nav-item"><a class="nav-link" href="<?= $base ?>/pages/relasi_list.php">Relasi</a></li>
            <li class="nav-item"><a class="nav-link" href="<?= $base ?>/pages/absensi_list.php">Absensi</a></li>
            <li class="nav-item"><a class="nav-link" href="<?= $base ?>/pages/hafalan_list.php">Hafalan</a></li>
            <li class="nav-item"><a class="nav-link" href="<?= $base ?>/pages/pengumuman_list.php">Pengumuman</a></li>
          <?php endif; ?>
          <?php if (user_role() === 'wali'): ?>
            <li class="nav-item"><a class="nav-link" href="<?= $base ?>/pages/wali_dashboard.php">Anak Saya</a></li>
            <li class="nav-item"><a class="nav-link" href="<?= $base ?>/pages/wali_pengumuman.php">Pengumuman</a></li>
          <?php endif; ?>
        <?php endif; ?>
      </ul>
      <ul class="navbar-nav">
        <?php if (is_logged_in()): ?>
          <li class="nav-item"><span class="nav-link">Halo, <?= htmlspecialchars(current_user()['name']) ?></span></li>
          <li class="nav-item"><a class="btn btn-outline-danger btn-sm ms-2" href="<?= $base ?>/logout.php">Logout</a></li>
        <?php else: ?>
          <li class="nav-item"><a class="btn btn-primary btn-sm" href="<?= $base ?>/login.php">Login</a></li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>
<div class="container mb-5">
